unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, SURandom, Dialogs, SUDatabase, StdCtrls,
  Controls, ExtCtrls, Classes, Graphics, Forms;

type
  TfmMain = class(TForm)
    lbUsers: TListBox;
    Panel1: TPanel;
    bbOpen: TButton;
    bbSave: TButton;
    bbAdd: TButton;
    bbDelete: TButton;
    bbChange: TButton;
    bbVerify: TButton;
    OpenDialog: TOpenDialog;
    bbCreate: TButton;
    SaveDialog: TSaveDialog;
    FastRandomGenerator: TSUFastRandomGenerator;
    BinaryPasswordDatabase: TSUBinaryPasswordDatabase;
    TextPasswordDatabase: TSUTextPasswordDatabase;
    procedure bbOpenClick(Sender: TObject);
    procedure bbSaveClick(Sender: TObject);
    procedure bbAddClick(Sender: TObject);
    procedure bbCreateClick(Sender: TObject);
    procedure bbDeleteClick(Sender: TObject);
    procedure bbChangeClick(Sender: TObject);
    procedure bbVerifyClick(Sender: TObject);
  private
    { Private declarations }
    FPasswordDatabase: TSUPasswordDatabase;

    procedure Refresh;
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation

{$R *.dfm}

uses NewUserFrm, StorageTypeFrm;

procedure TfmMain.bbSaveClick(Sender: TObject);
begin
  FPasswordDatabase.Save();
end;

procedure TfmMain.bbVerifyClick(Sender: TObject);
var
  Username, Password: string;
begin
  if lbUsers.ItemIndex < 0 then
    Exit;

  if InputQuery('Password', 'Enter a password:', Password) then
  begin
    Username := lbUsers.Items[lbUsers.ItemIndex];

    if FPasswordDatabase.Verify(Username, Password) then
      ShowMessage('Valid!')
    else
      ShowMessage('Invalid!');
  end;
end;

procedure TfmMain.Refresh;
var
  I: integer;
begin
  lbUsers.Items.Clear;
  for I := 0 to FPasswordDatabase.Count - 1 do
    lbUsers.Items.Add(FPasswordDatabase[I].Username);
end;

procedure TfmMain.bbAddClick(Sender: TObject);
var
  fmNewUser: TfmNewUser;
begin
  fmNewUser := TfmNewUser.Create(nil);
  try
    if fmNewUser.ShowModal <> mrOK then
      Exit;

    FPasswordDatabase.AddUser(fmNewUser.edUsername.Text, fmNewUser.edPassword.Text);
    Refresh;
  finally
    fmNewUser.Free;
  end;
end;

procedure TfmMain.bbChangeClick(Sender: TObject);
var
  fmNewUser: TfmNewUser;
begin
  fmNewUser := TfmNewUser.Create(nil);
  try
    if lbUsers.ItemIndex < 0 then
      Exit;

    fmNewUser.edUsername.Text := lbUsers.Items[lbUsers.ItemIndex];

    if fmNewUser.ShowModal <> mrOK then
      Exit;

    FPasswordDatabase.AddUser(fmNewUser.edUsername.Text, fmNewUser.edPassword.Text, true);
    Refresh;
  finally
    fmNewUser.Free;
  end;
end;

procedure TfmMain.bbCreateClick(Sender: TObject);
begin
  fmStorageType.ShowModal;

  if fmStorageType.StorageType = stBinary then
    FPasswordDatabase := BinaryPasswordDatabase
  else if fmStorageType.StorageType = stText then
    FPasswordDatabase := TextPasswordDatabase
  else
    Exit;

  if SaveDialog.Execute then
  begin
    FPasswordDatabase.CreateNew(SaveDialog.FileName);

    bbAdd.Enabled := true;
    bbDelete.Enabled := true;
    bbVerify.Enabled := true;
    bbChange.Enabled := true;
    bbSave.Enabled := true;
  end;
end;

procedure TfmMain.bbDeleteClick(Sender: TObject);
begin
  if lbUsers.ItemIndex >= 0 then
  begin
    FPasswordDatabase.DeleteUser(FPasswordDatabase.UIDs[lbUsers.Items[lbUsers.ItemIndex]]);
    Refresh;
  end;
end;

procedure TfmMain.bbOpenClick(Sender: TObject);
begin
  if not OpenDialog.Execute then
    Exit;

  fmStorageType.ShowModal;

  if fmStorageType.StorageType = stBinary then
    FPasswordDatabase := BinaryPasswordDatabase
  else if fmStorageType.StorageType = stText then
    FPasswordDatabase := TextPasswordDatabase
  else
    Exit;

  FPasswordDatabase.Open(OpenDialog.FileName);
  Refresh;

  bbAdd.Enabled := true;
  bbDelete.Enabled := true;
  bbVerify.Enabled := true;
  bbChange.Enabled := true;
  bbSave.Enabled := true;
end;

end.
